function [ covG,U, S, V, N, W ] = EstCovG(A,covE)
% [ covG,U, S, V, N, W ] = EstCovG(A,covE)
% Given a set of vct3 points A, computes the covariance of
% parameters G = [alpha, epsilon] associated with the solution
% of the Prokrustes problem
%       F*DeltaF(F)*A-B=E
% given information about the residual error vector E
%
%   A           vct3Array of points
%   CovE        given 3x3 covariance matrix of the E(i), or ...
%               if a vct3Array then computes the covariance matrix, or ...
%               if a scalar then assumes diag(e)
%
% Returns
%   covG        6x6 matrix cov(G)=cov([alpha,epsilon])
%   U,S,V       svd(CovG)
%   N           if CovE is a vct3Array, the number of points, else undef
%   W           if CovE is a vct3Array, then Mx of [sk(alpha)-epsilon], else undef
%
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

   if ~isa(A,'vct3Array')
       error('A must be vct3Array');
   end
   N=size(A.el,2);
   W = zeros(3*N,6);
   for i=1:(N-1)
       W((i-1)*3+1:i*3,:)= [skew(A(i)),-eye(3)];
   end
   [U,S,V]=svd(W,'econ');
   Si = diag(arrayfun(@(x)1/x,diag(S)));
   if isa(covE,'vct3Array')
       M = V*Si*U';
       EstCovE = cov(covE);
       covG = zeros(6);
       for i=1:(N-1)
           MM = M(:,(i-1)*3+1:i*3);
           covG = covG + MM*EstCovE*MM';
       end        
   elseif isscalar(covE)
       covG = covE*V*Si*Si*V';
   else
       if size(covE)~= [3 3]
           error('for now choices for covE are scalar, vct3Array or 3x3 matrix');
       end
       M = V*Si*U';
       covG = zeros(6);
       for i=1:(N-1)
           MM = M(:,(i-1)*3+1:i*3);
           covG = covG + MM*covE*MM';
       end
   end

end

